/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.logger;

import io.gitlab.jfronny.commons.logger.SystemLoggerPlus;
import io.gitlab.jfronny.commons.logger.impl.Formatter;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.ResourceBundle;

public class CompoundLogger
implements SystemLoggerPlus {
    private final String name;
    private final System.Logger[] loggers;

    public CompoundLogger(String name, System.Logger[] loggers) {
        this.name = name;
        this.loggers = loggers;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isLoggable(System.Logger.Level level) {
        for (System.Logger logger : this.loggers) {
            if (!logger.isLoggable(level)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle resourceBundle, String s, Throwable throwable) {
        for (System.Logger logger : this.loggers) {
            if (!logger.isLoggable(level)) continue;
            logger.log(level, resourceBundle, s, throwable);
        }
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle resourceBundle, String s, Object ... objects) {
        for (System.Logger logger : this.loggers) {
            if (!logger.isLoggable(level)) continue;
            logger.log(level, resourceBundle, s, objects);
        }
    }

    @Override
    public void log(System.Logger.Level level, ResourceBundle bundle, String format, Throwable t, Object ... params) {
        block3: for (System.Logger logger : this.loggers) {
            System.Logger logger2;
            Objects.requireNonNull(logger);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SystemLoggerPlus.class, System.Logger.class}, (Object)logger2, n)) {
                case 0: {
                    SystemLoggerPlus slp = (SystemLoggerPlus)logger2;
                    slp.log(level, bundle, format, t, params);
                    continue block3;
                }
                default: {
                    System.Logger sl = logger2;
                    sl.log(level, Formatter.format(bundle, format, params), t);
                }
            }
        }
    }
}

